<!-- SweetAlert2 Toast Notifications -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
  const Toast = Swal.mixin({
    toast: true,
    position: 'center', // 🔁 changed from 'top-end'
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true
  });


  document.addEventListener("DOMContentLoaded", function () {
    <?php if($errors->any()): ?>
      <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        Toast.fire({
          icon: 'error',
          title: <?php echo json_encode($error, 15, 512) ?>
        });
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(session('success')): ?>
      Toast.fire({
        icon: 'success',
        title: <?php echo json_encode(session('success'), 15, 512) ?>
      });
    <?php endif; ?>

    <?php if(session('error')): ?>
      Toast.fire({
        icon: 'error',
        title: <?php echo json_encode(session('error'), 15, 512) ?>
      });
    <?php endif; ?>

    <?php if(session('message')): ?>
      Toast.fire({
        icon: 'info',
        title: <?php echo json_encode(session('message'), 15, 512) ?>
      });
    <?php endif; ?>

    <?php if(session('vip_error')): ?>
      Swal.fire({
        icon: 'error',
        title: 'VIP Level Too Low',
        text: <?php echo json_encode(session('vip_error'), 15, 512) ?>,
        showCancelButton: true,
        confirmButtonText: 'Yes',
        cancelButtonText: 'Close',
        confirmButtonColor: '#004831',
        cancelButtonColor: '#d33'
      }).then((result) => {
        if (result.isConfirmed) {
          window.location.href = "<?php echo e(route('user.vip.details')); ?>";
        }
      });
    <?php endif; ?>
  });
</script>
<?php /**PATH /home/orbiywol/lcfworld.com/resources/views/alert-message.blade.php ENDPATH**/ ?>