<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover"/>
    <title>Withdraw</title>
    <link rel="icon" type="image/png" href="/static/img/images.png">
    <link rel="stylesheet" href="/static/reset.css"/>
    <link rel="stylesheet" href="/static/style.css"/>
    <link rel="stylesheet" href="/static/layui.css"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<style>
        /* Snackbar CSS *
        .snackbar {
            visibility: hidden;
            min-width: 250px;
            margin-left: -125px;
            background-color: #333;
            color: #fff;
            text-align: center;
            border-radius: 2px;
            padding: 16px;
            position: fixed;
            z-index: 1;
            left: 50%;
            bottom: 30px;
            font-size: 17px;
            opacity: 0;
            transition: opacity 0.5s, visibility 0.5s;
        }

        .snackbar.success {
            background-color: grey;
        }

        .snackbar.error {
            background-color: grey;
        }

        .snackbar.show {
            visibility: visible;
            opacity: 1;
        }*/
        
        /* Withdrawal Confirmation Modal */
        .withdraw-modal {
            display: none;
            position: fixed;
            z-index: 10000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            animation: fadeIn 0.3s;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        .withdraw-modal-content {
            background-color: #fff;
            margin: 10% auto;
            padding: 0;
            border-radius: 16px;
            width: 90%;
            max-width: 400px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
            animation: slideUp 0.3s;
        }
        
        @keyframes slideUp {
            from {
                transform: translateY(50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        .withdraw-modal-header {
            background: linear-gradient(to right, #004831, #003d28);
            color: white;
            padding: 20px;
            border-radius: 16px 16px 0 0;
            text-align: center;
            font-size: 20px;
            font-weight: bold;
        }
        
        .withdraw-modal-body {
            padding: 24px;
        }
        
        .withdraw-detail-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 0;
            border-bottom: 1px solid #eee;
        }
        
        .withdraw-detail-row:last-child {
            border-bottom: none;
            font-weight: bold;
            font-size: 18px;
            color: #004831;
            margin-top: 8px;
        }
        
        .withdraw-detail-label {
            color: #666;
            font-size: 15px;
        }
        
        .withdraw-detail-value {
            color: #333;
            font-size: 16px;
            font-weight: 600;
        }
        
        .withdraw-detail-row:last-child .withdraw-detail-value {
            color: #004831;
            font-size: 20px;
        }
        
        .withdraw-modal-footer {
            padding: 16px 24px 24px;
            display: flex;
            gap: 12px;
        }
        
        .withdraw-btn-confirm {
            flex: 1;
            background: #A0C81E;
            color: #000000;
            border: none;
            padding: 14px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .withdraw-btn-confirm:hover {
            background: #8fb01a;
        }
        
        .withdraw-btn-cancel {
            flex: 1;
            background: #ddd;
            color: #333;
            border: none;
            padding: 14px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .withdraw-btn-cancel:hover {
            background: #ccc;
        }
        
        /* Rule Number Styling */
        .rule-number {
            color: #004831;
            font-weight: 600;
            margin-right: 4px;
        }
        .wallet-btn {
            color: #000000 !important;
        }
    </style>
</head>
<body class="huiBg">
    <style>
        .top {
            background: #004831 !important;
        }
    </style>
    <div class="top">
        <a href="/home" class="topLeft">
            <i class="fas fa-arrow-left"></i>
        </a>
        <div class="topTit">Withdraw</div>
    </div>
    
    <!-- Show Success or Error Messages --
    <?php if(session('success')): ?>
        <div id="snackbar" class="snackbar success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div id="snackbar" class="snackbar error"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <!-- For Validation Errors --
    <?php if($errors->any()): ?>
        <div id="snackbar" class="snackbar error">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>-->

    <div class="wallet-box">
        <form id="withdrawForm" action="<?php echo e(route('user.withdraw.request')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="balance-list">
                <div class="balance-item">
                    <h3><?php echo e(price(auth()->user()->balance)); ?></h3>
                    <p>Withdrawable Balance</p>
                </div>
            </div>
            <div class="wallet-card">
                <h3>Holder Name</h3>
                <p><?php echo e(auth()->user()->realname); ?></p>
            </div>
            <div class="wallet-card">
                <h3>Account Number</h3>
                <p><?php echo e(auth()->user()->gateway_number); ?></p>
            </div>
            <div class="wallet-card">
                <h3>Bank Type</h3>
                <p><?php echo e(auth()->user()->bank_name); ?></p>
            </div>
            <div class="wallet-item">
                <h3>Withdraw Amount</h3>
                <div class="wallet-input">
                    <input type="number" id="withdrawAmount" name="amount" placeholder="Please enter withdraw amount" required>
                    <i>৳</i>
                </div>
            </div>
            <button type="button" id="withdrawBtn" class="wallet-btn">Withdraw</button>
        </form>
        <div class="wallet-rule">
            <p><strong> উত্তোলনের নিয়মাবলীঃ</strong></p>
            <p><span class="rule-number">১.</span> সর্বনিম্ন উত্তোলনের পরিমাণ ২০০ টাকা।</p>
            <p><span class="rule-number">২.</span> উত্তোলনের জন্য ১০% হ্যান্ডলিং ফি নেওয়া হবে।</p>
            <p><span class="rule-number">৩.</span> উত্তোলনের সময়: সোমবার থেকে শুক্রবার 12:00 PM - 07:00 PM.</p>
            <p><span class="rule-number">৪.</span> অনুগ্রহ করে সঠিক ব্যাঙ্ক তথ্য প্রদান করুন। তথ্য ভুল হলে, আপনার ব্যাঙ্ক অ্যাকাউন্টে তহবিল স্থানান্তর করা হবে না।</p>
        </div>
    </div>
    <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <!-- Withdrawal Confirmation Modal -->
    <div id="withdrawModal" class="withdraw-modal">
        <div class="withdraw-modal-content">
            <div class="withdraw-modal-header">
                <h2>Withdrawal Confirmation</h2>
            </div>
            <div class="withdraw-modal-body">
                <div class="withdraw-detail-row">
                    <span class="withdraw-detail-label">Withdrawal Amount:</span>
                    <span class="withdraw-detail-value" id="modalWithdrawAmount">৳ 0</span>
                </div>
                <div class="withdraw-detail-row">
                    <span class="withdraw-detail-label">Withdrawal Charge (<?php echo e($withdraw_charge ?? 10); ?>%):</span>
                    <span class="withdraw-detail-value" id="modalCharge">৳ 0</span>
                </div>
                <div class="withdraw-detail-row">
                    <span class="withdraw-detail-label">You Will Receive:</span>
                    <span class="withdraw-detail-value" id="modalFinalAmount">৳ 0</span>
                </div>
            </div>
            <div class="withdraw-modal-footer">
                <button type="button" class="withdraw-btn-cancel" id="cancelWithdraw">Cancel</button>
                <button type="button" class="withdraw-btn-confirm" id="confirmWithdraw">Confirm</button>
            </div>
        </div>
    </div>
    
    <script>
        const withdrawCharge = <?php echo e($withdraw_charge ?? 10); ?>;
        const withdrawForm = document.getElementById('withdrawForm');
        const withdrawBtn = document.getElementById('withdrawBtn');
        const withdrawAmountInput = document.getElementById('withdrawAmount');
        const withdrawModal = document.getElementById('withdrawModal');
        const cancelBtn = document.getElementById('cancelWithdraw');
        const confirmBtn = document.getElementById('confirmWithdraw');
        
        // Show modal when withdraw button is clicked
        withdrawBtn.addEventListener('click', function(e) {
            e.preventDefault();
            
            const amount = parseFloat(withdrawAmountInput.value);
            
            // Validate amount
            if (!amount || amount <= 0) {
                alert('Please enter a valid withdrawal amount');
                return;
            }
            
            // Calculate charge and final amount
            const charge = (amount * withdrawCharge) / 100;
            const finalAmount = amount - charge;
            
            // Update modal content
            document.getElementById('modalWithdrawAmount').textContent = '৳ ' + amount.toFixed(2);
            document.getElementById('modalCharge').textContent = '৳ ' + charge.toFixed(2);
            document.getElementById('modalFinalAmount').textContent = '৳ ' + finalAmount.toFixed(2);
            
            // Show modal
            withdrawModal.style.display = 'block';
        });
        
        // Close modal on cancel
        cancelBtn.addEventListener('click', function() {
            withdrawModal.style.display = 'none';
        });
        
        // Close modal when clicking outside
        window.addEventListener('click', function(event) {
            if (event.target == withdrawModal) {
                withdrawModal.style.display = 'none';
            }
        });
        
        // Submit form on confirm
        confirmBtn.addEventListener('click', function() {
            withdrawModal.style.display = 'none';
            withdrawForm.submit();
        });
    </script>
</body>
</html><?php /**PATH /home/orbiywol/lcfworld.com/resources/views/app/main/withdraw/index.blade.php ENDPATH**/ ?>