<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <title>Company Jobs</title>
    <link rel="icon" type="image/png" href="/static/img/images.png">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="<?php echo e(asset('public/assets/global-colors.css')); ?>">
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        body {
            background: #ffffff !important;
            font-family: 'Segoe UI', sans-serif;
            margin: 0;
            padding-bottom: 80px;
        }
        .header-area {
            background: linear-gradient(135deg, #004831, #003d28);
            padding: 14px 16px;
            color: #fff;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        .header-content {
            display: flex;
            align-items: center;
        }
        .back-btn {
            color: #fff;
            font-size: 24px;
            margin-right: 15px;
            text-decoration: none;
        }
        .back-btn:hover {
            color: #ccc;
        }
        .title {
            color: #fff;
            margin-bottom: 0;
            font-weight: 600;
            font-size: 18px;
        }
        .progress-bar {
            transition: width 0.6s ease;
        }
        .card {
            background: #f8f9fa;
            border-radius: 12px;
            border: 1px solid #eee;
        }
        .apply-btn {
            background: linear-gradient(135deg, #004831, #003d28);
            border: none;
            color: white;
            font-weight: 600;
        }
        .apply-btn:hover {
            opacity: 0.9;
            color: white;
        }
        .apply-btn:disabled {
            background: #ccc;
        }
    </style>
</head>
<body>
    <header class="header-area">
        <div class="container text-center">
            <div class="header-content">
                <a href="<?php echo e(route('dashboard')); ?>" class="back-btn"><i class='bx bx-left-arrow-alt'></i></a>
                <h4 class="title">Company Jobs</h4>
            </div>
        </div>
    </header>

    <div class="container mt-4">
        <?php $__currentLoopData = $positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card mb-3 shadow-sm">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h5 class="mb-0" style="color: #004831;"><?php echo e($position->title); ?></h5>
                        <span class="badge badge-success">Available</span>
                    </div>
                    
                    <p class="text-secondary small mb-3">
                        <i class="bx bx-info-circle text-primary"></i> 
                        When your <?php echo e($position->require_l1); ?> A-Grade team members become valid (min investment <?php echo e($minInvestment); ?>), you can apply. Monthly Salary: <?php echo e(number_format($position->salary)); ?> BDT.
                    </p>

                    <div class="referral-progress mb-3">
                        <div class="d-flex justify-content-between small mb-1">
                            <span>Level A Referrals</span>
                            <span class="font-weight-bold"><?php echo e($validL1); ?> / <?php echo e($position->require_l1); ?></span>
                        </div>
                        <div class="progress" style="height: 10px; background: #e9ecef; border-radius: 5px;">
                            <?php 
                                $percent = $position->require_l1 > 0 ? min(100, ($validL1 / $position->require_l1) * 100) : 100;
                            ?>
                            <div class="progress-bar" role="progressbar" style="width: <?php echo e($percent); ?>%; background-color: #004831;"></div>
                        </div>
                    </div>

                    <?php
                        $status = ($user_applications ?? [])[$position->id] ?? null;
                    ?>

                    <?php if($status == 'pending'): ?>
                        <button class="btn btn-secondary w-100 disabled" style="border-radius: 8px;">Pending Approval</button>
                    <?php elseif($status == 'approved' || $status == 'salary_paid'): ?>
                        <button class="btn btn-info w-100 disabled" style="border-radius: 8px;">Active Post</button>
                    <?php elseif($status == 'rejected'): ?>
                        <button class="btn btn-primary w-100 apply-btn" data-id="<?php echo e($position->id); ?>" style="border-radius: 8px;">Apply Again</button>
                    <?php else: ?>
                        <?php if($validL1 >= $position->require_l1): ?>
                            <button class="btn btn-primary w-100 apply-btn" data-id="<?php echo e($position->id); ?>" style="border-radius: 8px;">Apply Now</button>
                        <?php else: ?>
                            <div class="alert alert-warning py-2 px-3 small mb-2" style="border-radius: 8px;">
                                <i class="bx bx-error-circle"></i> Not eligible yet
                            </div>
                            <button class="btn w-100 disabled" style="border-radius: 8px; background: #eee; color: #999;">Apply Now</button>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <!-- Application History -->
        <div class="card mt-4 mb-5 shadow-sm">
            <div class="card-header bg-white">
                <h5 class="mb-0" style="color: #004831;"><i class="bx bx-history"></i> Application History</h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table mb-0 small">
                        <thead>
                            <tr>
                                <th>Position</th>
                                <th>Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $history ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->position->title); ?></td>
                                    <td><?php echo e($item->created_at->format('d M y')); ?></td>
                                    <td>
                                        <?php if($item->status == 'pending'): ?>
                                            <span class="badge badge-warning">Pending</span>
                                        <?php elseif($item->status == 'approved'): ?>
                                            <span class="badge badge-success">Approved</span>
                                        <?php elseif($item->status == 'rejected'): ?>
                                            <span class="badge badge-danger">Rejected</span>
                                        <?php elseif($item->status == 'superseded'): ?>
                                            <span class="badge badge-secondary">Superseded</span>
                                        <?php else: ?>
                                            <span class="badge badge-info"><?php echo e(ucfirst($item->status)); ?></span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center text-muted">No applications found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('app.layout.manu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).on('click', '.apply-btn', function() {
            let id = $(this).data('id');
            let btn = $(this);
            btn.prop('disabled', true).text('Processing...');

            $.ajax({
                url: "<?php echo e(route('user.job.apply')); ?>",
                method: "POST",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    position_id: id
                },
                success: function(response) {
                    if (response.status == 'success') {
                        Swal.fire({
                            title: 'Success!',
                            text: response.message,
                            icon: 'success',
                            confirmButtonColor: '#004831'
                        }).then(() => {
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            title: 'Oops...',
                            text: response.message,
                            icon: 'error',
                            confirmButtonColor: '#004831'
                        });
                        btn.prop('disabled', false).text('Apply Now');
                    }
                },
                error: function() {
                    Swal.fire({
                        title: 'Error!',
                        text: 'Something went wrong!',
                        icon: 'error',
                        confirmButtonColor: '#004831'
                    });
                    btn.prop('disabled', false).text('Apply Now');
                }
            });
        });
    </script>
</body>
</html>
<?php /**PATH /home/orbiywol/lcfworld.com/resources/views/app/main/job/index.blade.php ENDPATH**/ ?>