<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <title>Mine</title>
    <link rel="icon" type="image/png" href="/static/img/images.png">
    <link rel="stylesheet" href="/static/reset.css?v=<?php echo e(time()); ?>"/>
    <link rel="stylesheet" href="/static/style.css?v=<?php echo e(time()); ?>"/>
    <link rel="stylesheet" href="/static/layui.css?v=<?php echo e(time()); ?>"/>
    <script type="text/javascript" src="/static/layui.js"></script>
    <script type="text/javascript" src="/static/jquery-3.5.1.min.js"></script>
</head>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/layui@2.8.17/dist/css/layui.css" />
  <style>
    :root {
      --green: #004831;
      --green-dark: #003d28;
      --button: #A0C81E;
      --gray: #666;
      --bg: #f4f6f9;
    }

    * {
      box-sizing: border-box;
    }

    body {
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background: var(--bg);
      padding-bottom: 80px;
      color: #333;
    }

    a {
      color: inherit;
      text-decoration: none;
    }

    .welcome-message {
      position: absolute;
      top: 10px;
      right: 12px;
      background: linear-gradient(to right, var(--green), var(--green-dark));
      color: white;
      padding: 6px 12px;
      font-size: 12px;
      border-radius: 20px;
      animation: pulse 2s infinite;
      box-shadow: 0 0 10px rgb(228 228 223);
    }

    @keyframes pulse {
      0%, 100% { transform: scale(1); opacity: 0.9; }
      50% { transform: scale(1.05); opacity: 1; }
    }

    .top-bar {
      background: var(--green);
      padding: 16px;
      color: #fff;
      display: flex;
      align-items: center;
      position: relative;
      border-bottom: 3px solid #e6e6e6;
    }

    .top-bar img {
      width: 55px;
      height: 55px;
      border-radius: 50%;
      margin-right: 12px;
      border: 2px solid #fff;
    }

    .user-info .id {
      font-weight: bold;
      font-size: 16px;
    }

    .user-info .phone {
      font-size: 13px;
      opacity: 0.9;
    }

    .quick-actions,
    .more-actions {
      background: #fff;
      margin: 14px;
      border-radius: 16px;
      padding: 12px 0;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
      display: flex;
      justify-content: space-around;
      flex-wrap: wrap;
    }

    .action-item {
      text-align: center;
      width: 33.33%;
      margin: 12px 0;
      transition: transform 0.2s ease;
    }

    .action-item:hover {
      transform: scale(1.05);
    }

    .action-item img {
      width: 40px;
      height: 40px;
      margin-bottom: 6px;
      background: var(--button);
      padding: 6px;
      border-radius: 50%;
    }

    .stats {
      background: var(--green);
      margin: 14px;
      border-radius: 16px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      color: white;
    }

    .stat-box {
      padding: 16px;
      border-bottom: 1px solid #eee;
      border-right: 1px solid #eee;
      text-align: center;
    }

    .stat-box:nth-child(2n) { border-right: none; }
    .stat-box:nth-last-child(-n+2) { border-bottom: none; }

    .stat-value {
      font-weight: bold;
      font-size: 25px;
      color: var(--green);
    }

    .stat-label {
      font-size: 17px;
      color: var(--gray);
      margin-top: 3px;
    }

    .logout-btn {
      background: var(--button);
      margin: 24px 14px;
      padding: 14px;
      text-align: center;
      border-radius: 30px;
      font-weight: bold;
      color: #000000;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .logout-btn:hover {
      transform: scale(1.03);
      background: #8fb01a;
    }

    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      display: flex;
      justify-content: space-around;
      background: #fff;
      border-top: 1px solid #ddd;
      padding: 8px 0;
      box-shadow: 0 -2px 6px rgba(0, 0, 0, 0.05);
    }

    .bottom-nav a {
      text-align: center;
      font-size: 12px;
      color: #999;
      display: flex;
      flex-direction: column;
      align-items: center;
      transition: 0.3s;
    }

    .bottom-nav a img {
      width: 22px;
      margin-bottom: 2px;
    }

    .bottom-nav a.active {
      color: var(--green);
    }

    .bottom-nav a.active img {
      filter: brightness(1.3);
    }
    
    .name{
position: absolute;
top: 15%;
left: 50%;
transform: translate(-50%, -50%);
color:white;
    }
    
    

.logout-btn a {
    display: block; 
}
    
    
    
  </style>
</head>
<body>

  <div class="top-bar">
    <img src="https://aicash365.com/static/img/aicashlogo.jpeg" alt="Logo">
    <div class="user-info">
      <div class="id">
        ID: <?php echo e(auth()->user()->ref_id); ?> 
      </div>
      <div class="phone">Account: <?php echo e(auth()->user()->phone); ?></div>
    </div>
    
  </div>

  <!--<div class="quick-actions">
    <a href="/recharge" class="action-item">
      <img src="/public/images/profile/m_6.png" alt="Recharge">
      <div>Recharge</div>
    </a>
    <a href="/withdraw" class="action-item">
      <img src="/public/images/profile/m_6.png" alt="Withdraw">
      <div>Withdraw</div>
    </a>
    <a href="/record" class="action-item">
      <img src="/public/images/profile/m_6.png" alt="Record">
      <div>Record</div>
    </a>
  </div>-->
  <div class="stats">
    <div class="stat-box">
      <div class="stat-value" style="color: white;" data-count="<?php echo e((auth()->user()->balance + auth()->user()->deposit_wallet)); ?>">৳0.00</div>
      <div class="stat-label" style="color: rgba(255,255,255,0.8);">Total Balance</div>
    </div>
    <div class="stat-box">
      <div class="stat-value" style="color: white;" data-count="<?php echo e((auth()->user()->balance)); ?>">৳0.00</div>
      <div class="stat-label" style="color: rgba(255,255,255,0.8);">Withdrawable</div>
    </div>
  </div>
  <!--<div class="my-main">-->
    <div class="my-income-link">
        <a onclick="window.location.href='<?php echo e(route('user.deposit')); ?>'">
            <img src="/public/images/profile/m_2.png" alt="">Recharge
        </a>
        <a href="/withdraw">
            <img src="/public/images/profile/m_1.png" alt="">Withdraw
        </a>
    </div>

    <!--<div class="my-income-list" style="justify-content: space-evenly;">
        <div class="my-income-item">
            <h3>₦ <?php echo e((auth()->user()->balance)); ?></h3>
            <p>Withdraw Wallet</p>
        </div>
        <div class="my-income-item">
            <h3>₦ <?php echo e((auth()->user()->deposit_wallet)); ?></h3>
            <p>Recharge Wallet</p>
        </div>

   <!-- </div>
  <div class="my-income-list">
    <div class="my-income-item">
        
        <h3>₦ <?php echo e((auth()->user()->today_income)); ?></h3>
        <p>Today Income</p>
    </div>

    <div class="my-income-item">
        <h3>₦ <?php echo e((auth()->user()->team_income)); ?></h3>
        <p>Team Income</p>
    </div>
    <div class="my-income-item">
        <h3>₦ <?php echo e((auth()->user()->total_income)); ?></h3>
        <p>Total Income</p>
    </div>
</div>-->
<?php
    $walletTotal = 
        (auth()->user()->balance ?? 0) +
        (auth()->user()->deposit_wallet ?? 0) +
        (auth()->user()->today_income ?? 0) +
        (auth()->user()->team_income ?? 0) +
        (auth()->user()->total_income ?? 0);
?>


  

  <!--div class="more-actions">
    <a href="/bank" class="action-item">
      <img src="https://img.icons8.com/ios-filled/50/ffffff/bank.png" alt="Bank">
      <div>Bank</div>
    </a>
    <a href="/password" class="action-item">
      <img src="https://img.icons8.com/ios-filled/50/ffffff/lock.png" alt="Password">
      <div>Password</div>
    </a>
    <a href="/channel" class="action-item">
      <img src="https://img.icons8.com/ios-filled/50/ffffff/telegram-app.png" alt="Channel">
      <div>Channel</div>
    </a>
    <a href="/support" class="action-item">
      <img src="https://img.icons8.com/ios-filled/50/ffffff/online-support.png" alt="Service">
      <div>Service</div>
    </a>
  </div>-->
  <div class="my-top-nav">
        <ul>
            <li>
                <a href="/ordered">
                    <img src="/public/images/profile/m_5.png" alt="">
                    <p>My Product</p>
                </a>
            </li>
            <li>
                <a href="/add-bank">
                    <img src="/public/images/profile/m_3.png" alt="">
                    <p>Bind Account</p>
                </a>
            </li>
            <li>
                <a href="/aicash.apk">
                    <img src="/public/images/profile/m_12.png" alt="">
                    <p>App</p>
                </a>
            </li>
        <li>
                <a href="/history">
                    <img src="/public/images/profile/m_6.png" alt="">
                    <p>Account History</p>
                </a>
            </li>
            <!--li>
                <a href="/services">
                    <img src="/public/images/profile/m_9.png" alt="">
                    <p>Service</p>
                </a>
            </li>
            <!--<li>
                <a href="/my-team">
                    <img src="/public/images/profile/m_10.png" alt="">
                    <p>Invite</p>
                </a>
            </li>-->
            <li>
                <a href="/change/password">
                    <img src="/public/images/profile/m_7.png" alt="">
                    <p>Password</p>
                </a>
            </li>
             <li>
                <a href="/wheel">
                    <img src="/public/images/profile/spin-wheel-icon-free-vector-removebg-preview.png" alt="">
                    <p>Lucky Spin</p>
                </a>
            </li>
            <!--<li>
                <a href="/logout">
                    <img src="/public/images/profile/m_8.png" alt="">
                    <p>Logout</p>
                </a>
            </li>-->
        </ul>
    </div>
</div>

  <div class="logout-btn">
      <a href="/logout">Sign Out</a></div>
 
 <?php echo $__env->make('app.layout.manu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <!--div class="bottom-nav">
    <a href="/home">
      <img src="https://img.icons8.com/ios-filled/50/999999/home.png" alt="Home">
      Home
    </a>
    <a href="/benefits">
      <img src="https://img.icons8.com/ios-filled/50/999999/gift.png" alt="Benefits">
      Benefits
    </a>
    <a href="/official">
      <img src="https://img.icons8.com/ios-filled/50/999999/star.png" alt="Official">
      Official
    </a>
    <a href="/team">
      <img src="https://img.icons8.com/ios-filled/50/999999/groups.png" alt="Team">
      Team
    </a>
    <a href="/my" class="active">
      <img src="https://img.icons8.com/ios-filled/50/55b432/user.png" alt="My">
      My
    </a>
  </div>-->

  <script>
    // Animate numbers
    const counters = document.querySelectorAll('.stat-value');
    counters.forEach(counter => {
      let target = parseFloat(counter.getAttribute('data-count'));
      let count = 0;
      let step = target / 40;
      let interval = setInterval(() => {
        count += step;
        if (count >= target) {
          count = target;
          clearInterval(interval);
        }
        counter.innerText = '৳' + count.toFixed(2);
      }, 30);
    });

    // Optional: welcome alert
    setTimeout(() => {
      //alert("ðŸŽ‰ Welcome back to your dashboard!");
    }, 1000);
  </script>
</body>
</html>
<?php /**PATH /home/orbiywol/lcfworld.com/resources/views/app/main/profile.blade.php ENDPATH**/ ?>