<?php $__env->startSection('admin_content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Referral Ranking</h4>
                    <p>Users ranked by their referrals' total recharge amount.</p>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table table-striped datatable">
                                <thead>
                                    <tr>
                                        <th>Rank</th>
                                        <th>Username</th>
                                        <th>Name</th>
                                        <th>Phone</th>
                                        <th>Total Referrals</th>
                                        <th>Active Referrals</th>
                                        <th>Referrals Total Recharge</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(($users->currentPage() - 1) * $users->perPage() + $loop->iteration); ?></td>
                                            <td><?php echo e($user->username); ?></td>
                                            <td><?php echo e($user->name); ?></td>
                                            <td><?php echo e($user->phone); ?></td>
                                            <td><span class="badge badge-light-secondary"><?php echo e($user->total_referrals_count); ?></span></td>
                                            <td><span class="badge badge-light-primary"><?php echo e($user->active_referrals_count); ?></span></td>
                                            <td><span class="badge badge-light-success">৳<?php echo e(number_format($user->referrals_total_recharge, 2)); ?></span></td>
                                            <td>
                                                <a href="<?php echo e(route('admin.customer.login', $user->id)); ?>" class="btn btn-sm btn-primary">Login</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-2">
                            <?php echo e($users->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/orbiywol/lcfworld.com/resources/views/admin/pages/users/referral-ranking.blade.php ENDPATH**/ ?>