<?php $__env->startSection('admin_content'); ?>
<section id="dashboard-ecommerce">
    <div class="row">
        <div class="col-sm-12">
            <div class="card shadow-sm">
                <div class="card-header pb-0">
                    <h4 class="card-title">
                        <div class="d-flex justify-content-between align-items-center">
                            <span>📦 Package Lists</span>
                            <a href="<?php echo e(route('admin.package.create')); ?>" class="btn btn-primary btn-sm">
                                <i class="bx bx-plus"></i> Add New Item
                            </a>
                        </div>
                    </h4>
                </div>

                <div class="card-body card-dashboard">
                    <div class="table-responsive">
                        <table class="table table-striped dataex-html5-selectors">
                            <thead class="thead-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Order</th>
                                    <th>Name</th>
                                    <th>Photo</th>
                                    <th>Price</th>
                                    <th>Validity</th>
                                    <th>Buy Limit</th>
                                    <th>Status</th>
                                    <th>Type</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td>
                                        <!-- Up/Down Buttons -->
                                        <?php if($key > 0): ?>
                                            <a href="<?php echo e(route('admin.package.moveUp', $row->id)); ?>" 
                                               class="btn btn-sm btn-outline-primary" 
                                               data-toggle="tooltip" 
                                               title="Move Up">
                                                <i class="bx bx-up-arrow-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <?php if($key < count($packages) - 1): ?>
                                            <a href="<?php echo e(route('admin.package.moveDown', $row->id)); ?>" 
                                               class="btn btn-sm btn-outline-primary" 
                                               data-toggle="tooltip" 
                                               title="Move Down">
                                                <i class="bx bx-down-arrow-alt"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($row->name); ?></td>
                                    <td>
                                        <img src="<?php echo e(asset(view_image($row->photo))); ?>" alt="Package Photo" width="40" class="img-thumbnail">
                                    </td>
                                    <td>₦<?php echo e(number_format($row->price, 2)); ?></td>
                                    <td><?php echo e($row->validity); ?> Days</td>
                                    <td><?php echo e($row->buy_limit ?? 'Unlimited'); ?></td>
                                    <td>
                                        <?php if($row->status === 'active'): ?>
                                            <span class="badge badge-success">Active</span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(ucfirst($row->type)); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.package.view', $row->id)); ?>"
                                           class="btn btn-info btn-sm" data-toggle="tooltip" title="View">
                                            <i class="bx bx-show"></i>
                                        </a>

                                        <a href="<?php echo e(route('admin.package.create', $row->id)); ?>"
                                           class="btn btn-warning btn-sm" data-toggle="tooltip" title="Edit">
                                            <i class="bx bx-edit-alt"></i>
                                        </a>

                                        <?php if($row->id != 1): ?>
                                            <form method="POST" action="<?php echo e(route('admin.package.delete', $row->id)); ?>" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit"
                                                    class="btn btn-danger btn-sm"
                                                    onclick="return confirm('Are you sure you want to delete this package?')"
                                                    data-toggle="tooltip" title="Delete">
                                                    <i class="bx bx-trash"></i>
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div> <!-- .table-responsive -->
                </div> <!-- .card-body -->
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/orbiywol/lcfworld.com/resources/views/admin/pages/package/index.blade.php ENDPATH**/ ?>