<?php $__env->startSection('admin_content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Approved Jobs / Pay Salary</h4>
                </div>
                <div class="card-content">
                    <div class="card-body card-dashboard">
                        
                        <!-- Search Form -->
                        <form action="<?php echo e(route('admin.job.application.approved')); ?>" method="GET" class="mb-3">
                            <div class="row">
                                <div class="col-md-4">
                                    <input type="text" name="search" class="form-control" placeholder="Search by Username or Name..." value="<?php echo e($search); ?>">
                                </div>
                                <div class="col-md-2">
                                    <button type="submit" class="btn btn-primary">Search</button>
                                </div>
                            </div>
                        </form>

                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>User</th>
                                        <th>Position</th>
                                        <th>Salary</th>
                                        <th>Last Salary Paid</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($app->user->username); ?> (<?php echo e($app->user->name); ?>)</td>
                                            <td><?php echo e($app->position->title); ?></td>
                                            <td><?php echo e(price($app->position->salary)); ?></td>
                                            <td>
                                                <?php if($app->paid_at): ?>
                                                    <span class="text-success"><?php echo e(\Carbon\Carbon::parse($app->paid_at)->format('d M Y H:i')); ?></span>
                                                <?php else: ?>
                                                    <span class="text-warning">Never Paid</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('admin.job.application.pay', $app->id)); ?>" class="btn btn-sm btn-info" onclick="return confirm('Are you sure you want to pay salary to this user?')">Pay Salary</a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="5" class="text-center">No approved applications found.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-2">
                            <?php echo e($applications->appends(['search' => $search])->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.partials.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/orbiywol/lcfworld.com/resources/views/admin/pages/job/approved_applications.blade.php ENDPATH**/ ?>