<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8"/>
  <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Recharge</title>
  <link rel="stylesheet" href="[https://cdnjs.cloudflare.com/ajax/libs/layui/2.9.13/css/layui.css](https://cdnjs.cloudflare.com/ajax/libs/layui/2.9.13/css/layui.css)">
  <link rel="icon" type="image/png" href="/static/img/images.png">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/layui/2.9.13/css/layui.css">
  <link rel="stylesheet" href="<?php echo e(asset('public/')); ?>/static/reset.css"/>
  <link rel="stylesheet" href="<?php echo e(asset('public/')); ?>/static/style.css"/>
  <link rel="stylesheet" href="<?php echo e(asset('public/')); ?>/static/layui.css"/>
  <script src="<?php echo e(asset('public/')); ?>/static/jquery-3.5.1.min.js"></script>
  <script src="<?php echo e(asset('public/')); ?>/static/layui.js"></script>
  <style>
  .balance-list {
    width: 100%;
    height: auto;
    display: flex;
    align-items: center;
    justify-content: center;
    background: #004831;
    border-radius: 4px;
    margin-top: 12px;
    padding: 24px 6px;
}
    /*.wallet-channel-item {
      padding: 10px;
      margin-bottom: 10px;
      border: 2px solid #ccc;
      cursor: pointer;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    .wallet-channel-item.active {
      border-color: #6366f1;
      background-color: #eef2ff;
    }*/

    /*.wallet-btn {
      margin-top: 20px;
      padding: 12px;
      width: 100%;
      background-color: #4f46e5;
      color: white;
      border: none;
      cursor: pointer;
      font-weight: bold;
      border-radius: 4px;
    }
    .wallet-btn:hover {
      background-color: #4338ca;
    }*/

    .amount-options {
      display: flex;
      gap: 10px;
      flex-wrap: wrap;
      margin-top: 10px;
    }
    .amount-option {
      flex: 1 0 30%;
      padding: 12px 0;
      text-align: center;
      background: #fff;
      border: 2px solid #ccc;
      border-radius: 6px;
      cursor: pointer;
      font-weight: 600;
    }
    .amount-option.active {
      border-color: #004831;
      background: #fff;
      color: #004831;
    }

   /* #snackbar {
      display: none;
      position: fixed;
      left: 50%;
      top: 50%;
      transform: translate(-50%, -50%);
      background-color: #333;
      color: #fff;
      padding: 16px;
      border-radius: 5px;
      z-index: 1000;
      opacity: 0;
    }

    #snackbar.show {
      visibility: visible;
      opacity: 1;
    }*/
    .wallet-btn {
        color: #000000 !important;
    }
  </style>
</head>
<body class="huiBg">

<div class="top">
  <a href="<?php echo e(route('dashboard')); ?>" class="topLeft">
    <i class="layui-icon layui-icon-left"></i>
  </a>
  <div class="topTit">Recharge</div>
</div>

<div class="wallet-box">
  <div class="balance-list">
    <div class="balance-item">
      <h3> <?php echo e(price(auth()->user()->balance)); ?></h3>
      <p>Balance</p>
      
    </div>
  </div>

  <!--<div class="record-tab">
    <a href="/deposit" class="active">BANK</a>
  </div>-->

  <div class="wallet-item">
    <h3>Amount </h3>
    <div class="wallet-input">
      <input id="amount" type="number" name="amount" placeholder="Please enter recharge amount" value="" required>
      <i><?php echo e(currency()); ?></i>
    </div>

    <div class="amount-options">
      <div class="amount-option" onclick="selectAmount(400)">৳400</div>
      <div class="amount-option" onclick="selectAmount(1200)">৳1200</div>
      <div class="amount-option" onclick="selectAmount(2500)">৳2500</div>
      <div class="amount-option" onclick="selectAmount(6000)">৳6000</div>
      <div class="amount-option" onclick="selectAmount(10760)">৳10760</div>
      <div class="amount-option" onclick="selectAmount(17000)">৳17000</div>
      <div class="amount-option" onclick="selectAmount(35000)">৳35000</div>
      <div class="amount-option" onclick="selectAmount(50000)">৳50000</div>
      
    </div>
  </div>

  <div class="wallet-item">
    <h3>Recharge Channel</h3>
    <div class="wallet-channel">
      <?php
        $paymentMethods = \App\Models\PaymentMethod::where('status', 'active')->get();
      ?>
      <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="wallet-channel-item" data-id="<?php echo e($element->id); ?>"
             onclick="selectMethod('<?php echo e($element->id); ?>', '<?php echo e($element->id); ?>')">
          <?php echo e($element->name); ?>

          <i class="layui-icon-ok-circle"></i>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>

  <button type="button" class="wallet-btn" onclick="go_payment()">Recharge</button>

  <div class="wallet-rule">
    <p><strong>রিচার্জের নিয়মাবলী: </strong></p>
    <p><strong> ১. সর্বনিম্ন রিচার্জের পরিমাণ ৪০০।  </strong></p>
    <p><strong> ২. প্রতিবার রিচার্জের সময়, আপনাকে ক্যাশিয়ারে গ্রহণকারী অ্যাকাউন্ট পুনরায় সংগ্রহ করতে হবে।  </strong></p>
    <p><strong>৩. ট্রান্সফারের পরিমাণ অবশ্যই আপনার তৈরি করা পেমেন্ট অনুরোধের পরিমাণের সাথে মিলতে হবে, অন্যথায় অ্যাকাউন্ট ব্যালেন্সে জমা হবে না। </strong></p>
    <p><strong>৪. আপনি ২৪ ঘন্টা রিচার্জ করতে পারবেন। </strong></p>
    <p><strong>৫. রিচার্জ সংক্রান্ত প্রশ্নের জন্য, অনলাইন কাস্টমার সেবার সাথে যোগাযোগ করুন।  </strong></p>
    
  </div>
</div>

<div id="snackbar"></div>
<?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<form id="rechargeForm" method="POST" style="display:none;">
  <input type="hidden" name="amount">
  <input type="hidden" name="userPhone">
</form>

<script>
  // Message function using SweetAlert2
  function message(text) {
    const Toast = Swal.mixin({
      toast: true,
      position: 'center',
      showConfirmButton: false,
      timer: 3000,
      timerProgressBar: true
    });
    
    Toast.fire({
      icon: 'error',
      title: text
    });
  }

  function selectMethod(selected_method_id, selectMethodName) {
    const methodItems = document.querySelectorAll('.wallet-channel-item');
    methodItems.forEach(item => item.classList.remove('active'));

    const selectedItem = document.querySelector(`.wallet-channel-item[data-id="${selected_method_id}"]`);
    if (selectedItem) {
      selectedItem.classList.add('active');
    }

    selectedPaymentMethod = { id: selected_method_id, name: selectMethodName };
  }

  function selectAmount(value) {
    const input = document.getElementById('amount');
    input.value = value;

    const buttons = document.querySelectorAll('.amount-option');
    buttons.forEach(btn => btn.classList.remove('active'));

    event.target.classList.add('active');
  }

  function go_payment() {
    const amount = document.getElementById('amount').value;

    if (!selectedPaymentMethod) {
      message('Please select a payment method');
      return;
    }
    
    // Check if amount is empty
    if (!amount || amount.trim() === '') {
      message('Please fill out this field');
      return;
    }
    
    // Check minimum amount
    if (isNaN(amount) || parseFloat(amount) < 100) {
      message('Minimum Recharge ৳100.00');
      return;
    }
    
   
    window.location.href = `<?php echo e(url('user/payment')); ?>/${amount}/${selectedPaymentMethod.name}`;
  }

  document.addEventListener('DOMContentLoaded', () => {
    const firstMethod = document.querySelector('.wallet-channel-item');
    if (firstMethod) {
      const firstMethodId = firstMethod.getAttribute('data-id');
      const firstMethodName = firstMethod.textContent.trim();
      selectMethod(firstMethodId, firstMethodId);
    }
  });
</script>
</body>
</html><?php /**PATH /home/orbiywol/lcfworld.com/resources/views/app/main/deposit/index.blade.php ENDPATH**/ ?>